/** @file   shadowmanager.h
 * @brief   Declaration of ShadowManager - class. Contains also the
 *          inline implementations.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_SHADOWMANAGER_H
#define H_WWW_SHADOWMANAGER_H

#include <map>
#include "rect2d.h"

// Let the compiler know about the existance of this class.Forward declarations



namespace WeWantWar {

class ShadowTable;

/** @class  ShadowManager
 * @brief   Manages the dynamic shadows of the level.
 * @author  Tomi Lamminsaari
 *
 * The playfield has been divided in several sectors. The shadows of each
 * sector are manages by the certain ShadowTable - object. This class
 * manages all the ShadowTable - objects of the level.
 */
class ShadowManager
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================


  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   */
	ShadowManager();


	/** Destructor
   */
	virtual ~ShadowManager();

private:

	/** Copy constructor.
   * @param     rO                Reference to another ShadowManager
   */
  ShadowManager( const ShadowManager& rO );

	/** Assignment operator
   * @param     rO                Reference to another ShadowManager
   * @return    Reference to us.
   */
  ShadowManager& operator = ( const ShadowManager& rO );

public:



  ///
  /// Methods
  /// =======

  /** Initializes the shadow tables. This method expects that the tilemap
   * has been loaded already.
   */
  void buildShadows();
  
  /** Draws the contents of this shadowtable
   * @param     aTarget           Pointer to target bitmap
   * @param     aCenter           The center coordinate of the visible screen.
   */
  void applyShadows( BITMAP* aTarget, const eng2d::Vec2D& aCenter );
  
  /** Clears the contents of the dynamic shadows
   */
  void cleanup();
  


  ///
  /// Getter methods
  /// ==============
  
  


protected:

  /** Calculates the sector where the given point belongs to.
   * @param     aP                The point
   * @return    The sectornumber where the given point belongs to.
   */
  int getSectorNumber( const eng2d::Vec2D& aP ) const;
  
  
  ///
  /// Members
  /// =======
  
  /** The ShadowTable - objects are stored in this map. We use the
   * sectornumber as a key-value.
   */
  std::map< int, ShadowTable* > iShadows;


private:

  ///
  /// Private members
  /// ===============

};



};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: shadowmanager.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:15+02  lamminsa
 * Initial revision
 *
 */
 
